/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.util.ArrayList;
import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.Location;
import sedonac.ir.IrMethod;
import sedonac.ir.IrSlot;
import sedonac.ir.IrType;
import sedonac.namespace.TypeUtil;

public class FindTestCases
extends CompilerStep {
    public void run() {
        if (!this.compiler.image.test) {
            return;
        }
        this.log.debug("  FindTestCases");
        this.compiler.testMethods = FindTestCases.findTestMethods(this.flat.types, false);
        int n = 0;
        while (n < this.compiler.testMethods.length) {
            this.checkTestCase(this.compiler.testMethods[n]);
            ++n;
        }
    }

    private final void checkTestCase(IrMethod irMethod) {
        boolean bl;
        String string = irMethod.qname;
        Location location = new Location(string);
        boolean bl2 = false;
        if (irMethod.params.length > 0) {
            bl2 = bl = true;
        }
        if (!irMethod.isPublic()) {
            this.err("Test method '" + string + "' must be public", location);
        }
        if (!irMethod.isStatic()) {
            this.err("Test method '" + string + "' must be static", location);
        }
        if (irMethod.isAbstract()) {
            this.err("Test method '" + string + "' cannot be abstract", location);
        }
        if (irMethod.isNative()) {
            this.err("Test method '" + string + "' cannot be native", location);
        }
        if (!irMethod.ret.isVoid()) {
            this.err("Test method '" + string + "' return void", location);
        }
        if (bl) {
            this.err("Test method '" + string + "' cannot have parameters", location);
        }
    }

    public static IrMethod[] findTestMethods(IrType[] irTypeArray, boolean bl) {
        ArrayList<IrMethod> arrayList = new ArrayList<IrMethod>(100);
        int n = 0;
        while (n < irTypeArray.length) {
            IrType irType = irTypeArray[n];
            if (TypeUtil.isaTest(irType)) {
                int n2 = 0;
                while (n2 < irType.declared.length) {
                    IrSlot irSlot = irType.declared[n2];
                    if (irSlot instanceof IrMethod) {
                        IrMethod irMethod = (IrMethod)irSlot;
                        if (!(!irMethod.name.startsWith("test") || bl && irMethod.facets.getb("javaSkip", false))) {
                            arrayList.add(irMethod);
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return arrayList.toArray(new IrMethod[arrayList.size()]);
    }

    public FindTestCases(Compiler compiler) {
        super(compiler);
    }
}

